
import sys, os, re
import dateutil
from dateutil.parser import *

from datetime import timezone

import json

BASE_REPO_URL = "https://mirrors.slackware.com/slackware"

RELEASES = {
	'12.0': {"ports": ["x86"], "release_date": 1183347042},
	'12.1':  {"ports": ["x86"], "release_date": 1209666994 },
	'12.2':  {"ports": ["x86"], "release_date": 1228802423 },
	'13.0': {"ports": ["x86", "x86_64"], "release_date":1251298838},
	'13.1': {"ports": ["x86", "x86_64"], "release_date":1274259503},
	'13.37': {"ports": ["x86", "x86_64"], "release_date":1303738620},
	'14.0': {"ports": ["x86", "x86_64"], "release_date":1348621842},
	'14.1': {"ports": ["x86", "x86_64"], "release_date":1383584927},
	'14.2': {"ports": ["x86", "x86_64"], "release_date":1467318417 },
	'15.0': {"ports": ["x86", "x86_64"], "release_date": 1643840542},
	'current': {"ports": ["x86", "x86_64"], "release_date": 1467318417},
}

versions = [
	'12.0','12.1','12.2',
	'13.0','13.1','13.37',
	'14.0','14.1','14.2',
	'15.0',
	'current',
	]
versions64 = [
	'13.0','13.1','13.37',
	'14.0','14.1','14.2',
	'15.0',
	'current',
	]
	
''' 
	SEP
	
	This is the string used to signal a new changelog entry.
	Only guaranteed to work for versions 12.0 and newer.
	'''
SEP = "+--------------------------+"
def open_package_list(version, arch, name="PACKAGES.TXT"):
	#FILES = ['PACKAGES.TXT','PACKAGES_TESTING.TXT','PACKAGES_EXTRA.TXT'] 
	CHANGELOG_PATH='/srv/lg-web/data/slackware'
	if arch == "x86":
		arch_name = ""
	elif arch == "x86_64":
		arch_name = "64"
	
	path = CHANGELOG_PATH + '/slackware' + arch_name + '-' + version + '/PACKAGES.TXT'
	if not os.path.exists(path):
		print("Changelog does not exist!\ Downloading from internet..")
		#text = DistroStats.download_file( '/'.join([BASE_REPO_URL, 'slackware-' + version, 'ChangeLog.txt']) )
		text = None
	else:
		f = open(path, 'r')
		text = f.read()
		f.close()
	return text

'''
	open_changelog_file()
	
	Opens a changelog and reads the text. 
	Returns None if file does not exist.
'''
def open_changelog_file(version, arch):
	CHANGELOG_PATH='/srv/lg-web/data/slackware'
	if arch == "x86":
		arch_name = ""
	elif arch == "x86_64":
		arch_name = "64"
	
	path = CHANGELOG_PATH + '/slackware' + arch_name + '-' + version + '/ChangeLog.txt'
	if not os.path.exists(path):
		print("Changelog does not exist!\ Downloading from internet..")
		#text = DistroStats.download_file( '/'.join([BASE_REPO_URL, 'slackware-' + version, 'ChangeLog.txt']) )
		text = None
	else:
		f = open(path, 'r')
		text = f.read()
		f.close()
		
	return text.split(SEP)

'''
	parse_pkg_name():
	
	VERY simple function to parse a slackware package name
	
	This probably needs to be checked for accuracy and could stop
	working as expected if something changes in python.
'''
def parse_pkg_name(pkg_name, with_path=True):
	pkg = {
		"name":'',
		"version":'',
		"arch":'',
		"build":'',
		"format":'',
		"series":'',
	}
	
	if pkg_name.startswith("usb-and-pxe-installers/"):
		pkg['name'] = "USB_Installer"
		pkg['series'] = "install_media"
		return pkg
	elif pkg_name.startswith("kernels/"):
		pkg['name'] = "kernels"
		pkg['series'] = "install_media"
		
	p = pkg_name.split('-')
	if len(p) < 4:
		print(" -- WARNING! Not a valid package: ", p)
		return None
	'''
	if len(p) > 5:
		pkg['build'] = p.pop()
		pkg['arch'] = p.pop()
		pkg['version'] = p.pop()
		
		s_n = '-'.join(p).split('/')
		pkg['name'] =s_n[1]
		pkg['series'] =s_n[0]  + "/"
		return pkg
	'''
	
	#print("-- parsing", pkg_name)
	if "/" in pkg_name:
		with_path = True
	else:
		with_path= False
	if len(p) > 4:
		pkg['build'] = p.pop()
		pkg['arch'] = p.pop()
		pkg['version'] = p.pop()
		
		pkg['name'] = '-'.join(p)
		if with_path is True:
			s_n = pkg['name'].split('/')
			pkg['name'] = s_n.pop()
			pkg['series'] = s_n[0]
		return pkg
	else:
		pkg['build'] = p.pop()
		pkg['arch'] = p.pop()
		pkg['version'] = p.pop()
		
		pkg['name'] = p.pop()
		if with_path is True:
			s_n = pkg['name'].split('/')
			pkg['name'] = s_n.pop()
			pkg['series'] = s_n[0]
		
		return pkg
	return pkg

'''
	parse_chunk()
	Parses a changelog update.
	
	A "chunk" is defined as a datestamped block 
	of slackware updates after splitting on SEP. 
	
	This includes a single datestamp and 
	any number of package changes.
'''
def parse_chunk(chunk):
	#exp = r'[a-z].*\/.*\:.*'
	exp = r'.*(?:tgz|txz):.*'
	chunk_data = {
			'notice': "",
			'Patched': [],
			'Upgraded': [],
			'Updated': [],
			'Moved': [],
			'Added': [],
			'Removed': [],
			'Fixed':[],
			'Rebuilt': [],
			'Other': []
	}
	#print("Processing chunk:", chunk)
	if chunk == "\n":
		return None, None
	d = chunk.splitlines()
	
	# remove empty items from lists
	if d.count('') > 0:
		d.remove('')
	# convert datestamp to 'YYYYMMDD' format
	datestamp = normalize_timestamp(d.pop(0))
	# remove prologue notes
	#prologue = []
	#for l in d:
	#	if "tgz" in l or "txz" in l:
	#		break
	#	else:
	#		prologue.append( d.pop(d.index(l)) )
	
	# read bottom-top instead of top-to-bottom.
	# this is easier since I'm not smart enough to figure out 
	# how to parse the notes when they are listed 
	# AFTER the package they relate to. :(
	d.reverse()
	notes = []
	pkgs_changed = []
	for x in d:
		change = re.match(exp, x)
		if x.startswith("  "):
			notes.append(x)
		if change:
			spl = x.rstrip('.').split(':')
			spl[1] = spl[1].lstrip()
			pkg = parse_pkg_name(spl[0], with_path=True)
			if pkg == None:
				continue
			pkg['date'] = datestamp.isoformat()
			
			if spl[1].startswith("Patched"):
				pkg['change'] = "Patched"
			elif spl[1].startswith("Upgraded"):
				pkg['change'] = "Upgraded"
			elif spl[1].startswith("Updated"):
				pkg['change'] = "Updated"
			elif spl[1].startswith("Moved"):
				pkg['change'] = "Moved"
			elif spl[1].startswith("Added"):
				pkg['change'] = "Added"
			elif spl[1].startswith("Removed"):
				pkg['change'] = "Removed"
			elif spl[1].startswith("Fixed"):
				pkg['change'] = "Fixed"
			elif spl[1].startswith("Rebuilt"):
				pkg['change'] = "Rebuilt"
			else:
				pkg['change'] = "Other"

			
			if len(notes) > 0:
				# notes are backwards.. reverse them...
				notes.reverse()
				pkg['notice'] = '<br>'.join(notes)#.encode()
				# for some reason the . in certain files is replaced
				# with an escape character..
				pkg['notice'] = pkg['notice']#.replace('\x94','.')
				notes = []
			else:
				pkg['notice'] = ""
			
			if len(pkg['name']) < 50:
				pkgs_changed.append(pkg)

	#return datestamp.isoformat(), chunk_data
	return datestamp.isoformat(), pkgs_changed

'''
	normalize_timestamp()
	
	Slackware timestamps have not been 100% consistent over the years. 
	This function uses dateutils to perform more robust parsing.
'''
def normalize_timestamp(timestamp):
	#new_time = dateutil.parser.parse(timestamp, ignoretz=True)
	#tzinfos = {"UTC": , "CST": gettz("America/Chicago")}
	new_time = dateutil.parser.parse(timestamp, tzinfos={"UTC": 0, "CST": "UTC-6", "CDT": "UTC-5"})
	return new_time

def parse_package_list(version="current", arch="x86_64"):
	chunk_size = 14
	data = {}
	text = open_package_list(version, arch).split("\n")
	for x in txt:
		if x.startswith("PACKAGE NAME"):
			i = txt.index(x)
			pkg = parse_pkg_name(x.split(':')[1].lstrip(), with_path=False)
			series = txt[i+1].split(':')[1].lstrip().split('/')
			if "slackware" in series[1]:
				pkg['series'] = series.pop()
			else:
				pkg['series'] = series[1]
			desc = []
			for line in txt[i+5: i+16]:
				if line.startswith(pkg['name']):
					desc.append(line[len(pkg['name'])+2:])
			pkg['description'] = '<br>'.join(desc)
			self.pkg_list.append(pkg)
			self.data[pkg['name']] = pkg
class PackageList():
	def __init__(self, version="current", arch="x86_64"):
		text = open_package_list(version, arch).split("\n")
		
		self.pkg_list = []
		self.data = {}
		self.parse(text)
		
	def parse(self, txt):
		chunk_size = 14
		
		for x in txt:
			if x.startswith("PACKAGE NAME"):
				i = txt.index(x)
				pkg = parse_pkg_name(x.split(':')[1].lstrip(), with_path=False)
				series = txt[i+1].split(':')[1].lstrip().split('/')
				if "slackware" in series[1]:
					pkg['series'] = series.pop()
				else:
					pkg['series'] = series[1]
				desc = []
				for line in txt[i+5: i+16]:
					if line.startswith(pkg['name']):
						desc.append(line[len(pkg['name'])+2:])
				pkg['description'] = '<br>'.join(desc)
				self.pkg_list.append(pkg)
				self.data[pkg['name']] = pkg
